#!/usr/bin/env python
# encoding: utf-8
"""
base.py

Created by 寺田 学 on 2008-11-06.
Copyright (c) 2008 __MyCompanyName__. All rights reserved.
"""

from Testing import ZopeTestCase
from Products.Five import zcml
from Products.Five import fiveconfigure
from Products.PloneTestCase import PloneTestCase
from Products.PloneTestCase.layer import onsetup

@onsetup
def setup_p3sample():
    """Set up the additional products required for the Optilux site policy.
    
    The @onsetup decorator causes the execution of this body to be deferred
    until the setup of the Plone site testing layer.
    """    
    # Load the ZCML configuration for the optilux.policy package.
    fiveconfigure.debug_mode = True
    from Products import P3sample
    zcml.load_config('configure.zcml', P3sample)
    fiveconfigure.debug_mode = False
    
    # We need to tell the testing framework that these products
    # should be available. This can't happen until after we have loaded
    # the ZCML.
    
    ZopeTestCase.installPackage('P3sample')
    
# The order here is important: We first call the (deferred) function which
# installs the products we need for the Optilux package. Then, we let 
# PloneTestCase set up this product on installation.

setup_p3sample()

PRODUCTS = []
PloneTestCase.setupPloneSite(products=PRODUCTS)

class P3sampleTestCase(PloneTestCase.PloneTestCase):
    """ """
    class Session(dict):
        def set(self, key, value):
            self[key] = value
    
    def _setup(self):
        PloneTestCase.PloneTestCase._setup(self)
        self.app.REQUEST['SESSION'] = self.Session()


